function valida_mail(email) {
  var email_reg = /^[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,6}$/;
  return email_reg.test(email);
}
var reg_nome_cognome = /^[a-zA-ZàèéìòùÀÈÉÌÒÙ\-_ ’'‘ÆÐƎƏƐƔĲŊŒẞÞǷȜæðǝəɛɣĳŋœĸſßþƿȝĄƁÇĐƊĘĦĮƘŁØƠŞȘŢȚŦŲƯY̨Ƴąɓçđɗęħįƙłøơşșţțŧųưy̨ƴÁÀÂÄǍĂĀÃÅǺĄÆǼǢƁĆĊĈČÇĎḌĐƊÐÉÈĖÊËĚĔĒĘẸƎƏƐĠĜǦĞĢƔáàâäǎăāãåǻąæǽǣɓćċĉčçďḍđɗðéèėêëěĕēęẹǝəɛġĝǧğģɣĤḤĦIÍÌİÎÏǏĬĪĨĮỊĲĴĶƘĹĻŁĽĿʼNŃN̈ŇÑŅŊÓÒÔÖǑŎŌÕŐỌØǾƠŒĥḥħıíìiîïǐĭīĩįịĳĵķƙĸĺļłľŀŉńn̈ňñņŋóòôöǒŏōõőọøǿơœŔŘŖŚŜŠŞȘṢẞŤŢṬŦÞÚÙÛÜǓŬŪŨŰŮŲỤƯẂẀŴẄǷÝỲŶŸȲỸƳŹŻŽẒŕřŗſśŝšşșṣßťţṭŧþúùûüǔŭūũűůųụưẃẁŵẅƿýỳŷÿȳỹƴźżžẓ]*$/;
var reg_luogo_nascita_residenza = /^[A-Za-zàèéìòùÀÈÉÌÒÙ\s\-']{2,}$/;
var reg_indirizzo = /^[A-Za-z0-9àèéìòùÀÈÉÌÒÙ\s\-\.,']{3,}$/;
var reg_civico = /^\d+(\/[a-zA-Z])?$/;
var reg_mesi_due_cifre = /^\d{1,2}$/;


function controllaCFPIVA(sValue) {
  var bRc = true;
  var iOdd = 0;
  var iEven = 0;
  var iDouble = 0;
  var iCin = 0;
  var tabellaCF = new Array(36);
  var tabellaCFB = new Array(36);
  var tabellaCFA = new Array(36);
  if (sValue.length === 11) {
    iOdd = sValue.charAt(0) * 1 + sValue.charAt(2) * 1 + sValue.charAt(4) * 1 + sValue.charAt(6) * 1 + sValue.charAt(8) * 1;
    for (var i = 1; i < 11; i = i + 2) {
      iDouble = sValue.charAt(i) * 2;
      if (iDouble > 9)
        iEven += iDouble % 10 + 1;
      else
        iEven += iDouble;
    }
    iCin = (10 - (iEven + iOdd) % 10) % 10;
    if (iCin === (sValue.charAt(10) * 1))
      return true;
    else
      return false;
  } else {
    if (sValue.length === 16) {
      tabellaCF[0] = '0';
      tabellaCF[1] = '1';
      tabellaCF[2] = '2';
      tabellaCF[3] = '3';
      tabellaCF[4] = '4';
      tabellaCF[5] = '5';
      tabellaCF[6] = '6';
      tabellaCF[7] = '7';
      tabellaCF[8] = '8';
      tabellaCF[9] = '9';
      tabellaCF[10] = 'A';
      tabellaCF[11] = 'B';
      tabellaCF[12] = 'C';
      tabellaCF[13] = 'D';
      tabellaCF[14] = 'E';
      tabellaCF[15] = 'F';
      tabellaCF[16] = 'G';
      tabellaCF[17] = 'H';
      tabellaCF[18] = 'I';
      tabellaCF[19] = 'J';
      tabellaCF[20] = 'K';
      tabellaCF[21] = 'L';
      tabellaCF[22] = 'M';
      tabellaCF[23] = 'N';
      tabellaCF[24] = 'O';
      tabellaCF[25] = 'P';
      tabellaCF[26] = 'Q';
      tabellaCF[27] = 'R';
      tabellaCF[28] = 'S';
      tabellaCF[29] = 'T';
      tabellaCF[30] = 'U';
      tabellaCF[31] = 'V';
      tabellaCF[32] = 'W';
      tabellaCF[33] = 'X';
      tabellaCF[34] = 'Y';
      tabellaCF[35] = 'Z';
      for (var iTab = 0; iTab < 10; iTab++) {
        tabellaCFA[iTab] = iTab;
      }
      for (var iTab = 10; iTab < 36; iTab++)
        tabellaCFA[iTab] = iTab - 10;
      tabellaCFB[0] = 1;
      tabellaCFB[1] = 0;
      tabellaCFB[2] = 5;
      tabellaCFB[3] = 7;
      tabellaCFB[4] = 9;
      tabellaCFB[5] = 13;
      tabellaCFB[6] = 15;
      tabellaCFB[7] = 17;
      tabellaCFB[8] = 19;
      tabellaCFB[9] = 21;
      tabellaCFB[10] = 1;
      tabellaCFB[11] = 0;
      tabellaCFB[12] = 5;
      tabellaCFB[13] = 7;
      tabellaCFB[14] = 9;
      tabellaCFB[15] = 13;
      tabellaCFB[16] = 15;
      tabellaCFB[17] = 17;
      tabellaCFB[18] = 19;
      tabellaCFB[19] = 21;
      tabellaCFB[20] = 2;
      tabellaCFB[21] = 4;
      tabellaCFB[22] = 18;
      tabellaCFB[23] = 20;
      tabellaCFB[24] = 11;
      tabellaCFB[25] = 3;
      tabellaCFB[26] = 6;
      tabellaCFB[27] = 8;
      tabellaCFB[28] = 12;
      tabellaCFB[29] = 14;
      tabellaCFB[30] = 16;
      tabellaCFB[31] = 10;
      tabellaCFB[32] = 22;
      tabellaCFB[33] = 25;
      tabellaCFB[34] = 24;
      tabellaCFB[35] = 23;
      var tot = 0;
      var tmp = '';
      for (var iChar = 0; iChar < 15; iChar++) {
        tmp = sValue.charAt(iChar);
        var j = 0;
        for (j = 0; j < 36; j++) {
          if (tmp === tabellaCF[j])
            break;
        }
        if (j === 36)
          return false;
        if ((iChar % 2) === 0) {
          tot += tabellaCFB[j];
        } else {
          tot += tabellaCFA[j];
        }
      }
      tot %= 26;
      iCin = tabellaCF[tot + 10];
      if (iCin === sValue.charAt(15))
        return true;
      else
        return false;
    } else
      return false;
  }
}

function valida_nome(nome) {
  if (nome.length == 0) {
    $(`#nome_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_nome_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_nome_${get_tipo_beneficiario()}`).text("Nome obbligatorio.");
  }
  else if (nome.length < 2) {
    $(`#nome_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_nome_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_nome_${get_tipo_beneficiario()}`).text("Il nome deve avere almeno due caratteri.");
  }
  else {
    if (!reg_nome_cognome.test(nome)) {
      $(`#nome_${get_tipo_beneficiario()}`).addClass("is-invalid");
      $(`#errore_nome_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
      $(`#errore_nome_${get_tipo_beneficiario()}`).text("Hai inserito caratteri non consentiti.");
    } else {
      $(`#nome_${get_tipo_beneficiario()}`).removeClass("is-invalid");
      $(`#errore_nome_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
      $(`#errore_nome_${get_tipo_beneficiario()}`).text("");
    }
  }
}

function valida_cognome(cognome) {
  if (cognome.length == 0) {
    $(`#cognome_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_cognome_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_cognome_${get_tipo_beneficiario()}`).text("Cognome obbligatorio.");
  }
  else if (cognome.length < 2) {
    $(`#cognome_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_cognome_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_cognome_${get_tipo_beneficiario()}`).text("Il cognome deve avere almeno due caratteri.");
  }
  else {
    if (!reg_nome_cognome.test(cognome)) {
      $(`#cognome_${get_tipo_beneficiario()}`).addClass("is-invalid");
      $(`#errore_cognome_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
      $(`#errore_cognome_${get_tipo_beneficiario()}`).text("Hai inserito caratteri non consentiti.");
    } else {
      $(`#cognome_${get_tipo_beneficiario()}`).removeClass("is-invalid");
      $(`#errore_cognome_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
      $(`#errore_cognome_${get_tipo_beneficiario()}`).text("");
    }
  }
}

function valida_data_nascita(dataNascita) {
  const array_data = dataNascita.split("-");
  var anno = array_data[0];
  const idCampo = `#data-nascita_${get_tipo_beneficiario()}`; // usa il trattino
  const idErrore = `#errore_data_nascita_${get_tipo_beneficiario()}`;

  if (dataNascita === "") {
    $(idCampo).addClass("is-invalid");
    $(idErrore).addClass("invalid-feedback d-block");
    $(idErrore).text("Data di nascita obbligatoria.");
  }
  else if (anno < 1900 || anno > 2026) {
    $(idCampo).addClass("is-invalid");
    $(idErrore).addClass("invalid-feedback d-block");
    $(idErrore).text("Data di nascita non valida.");
  }
  else {
    $(idCampo).removeClass("is-invalid");
    $(idErrore).removeClass("invalid-feedback d-block");
    $(idErrore).text("");
  }
}

function valida_luogo_nascita(luogoNascita) {
  if (luogoNascita.length == 0) {
    $(`#luogo-nascita_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_luogo_nascita_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_luogo_nascita_${get_tipo_beneficiario()}`).text("Luogo di nascita obbligatorio.");
  }
  else if (!reg_luogo_nascita_residenza.test(luogoNascita)) {
    $(`#luogo-nascita_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_luogo_nascita_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_luogo_nascita_${get_tipo_beneficiario()}`).text("Luogo di nascita non valido.");
  }
  else {
    $(`#luogo-nascita_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_luogo_nascita_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_luogo_nascita_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_provincia_nascita(provinciaNascita) {
  if (provinciaNascita.length == 0) {
    $(`#provincia-nascita_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_provincia_nascita_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_provincia_nascita_${get_tipo_beneficiario()}`).text("Provincia di nascita obbligatoria.");
  } else if (!reg_luogo_nascita_residenza.test(provinciaNascita)) {
    $(`#provincia-nascita_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_provincia_nascita_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_provincia_nascita_${get_tipo_beneficiario()}`).text("Provincia di nascita non valida.");
  }
  else {
    $(`#provincia-nascita_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_provincia_nascita_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_provincia_nascita_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_residenza(residenza) {
  if (residenza.length == 0) {
    $(`#residenza_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_residenza_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_residenza_${get_tipo_beneficiario()}`).text("Comune di residenza obbligatorio.");
  } else if (!reg_luogo_nascita_residenza.test(residenza)) {
    $(`#residenza_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_residenza_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_residenza_${get_tipo_beneficiario()}`).text("Comune di residenza non valido.");
  } else {
    $(`#residenza_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_residenza_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_residenza_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_provincia(provincia) {
  if (provincia.length == 0) {
    $(`#provincia_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_provincia_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_provincia_${get_tipo_beneficiario()}`).text("Provincia obbligatoria.");
  } else if (!reg_luogo_nascita_residenza.test(provincia)) {
    $(`#provincia_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_provincia_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_provincia_${get_tipo_beneficiario()}`).text("Provincia non valida.");
  }
  else {
    $(`#provincia_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_provincia_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_provincia_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_indirizzo(indirizzo) {
  if (indirizzo.length == 0) {
    $(`#indirizzo_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_indirizzo_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_indirizzo_${get_tipo_beneficiario()}`).text("Indirizzo obbligatorio.");
  } else if (!reg_indirizzo.test(indirizzo)) {
    $(`#indirizzo_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_indirizzo_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_indirizzo_${get_tipo_beneficiario()}`).text("Indirizzo non valido.");
  } else {
    $(`#indirizzo_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_indirizzo_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_indirizzo_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_civico(civico) {
  if (civico.length == 0) {
    $(`#civico_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_civico_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_civico_${get_tipo_beneficiario()}`).text("Numero civico obbligatorio.");
  } else {
    $(`#civico_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_civico_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_civico_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_email(email) {
  if (email.length == 0) {
    $(`#email_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_email_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_email_${get_tipo_beneficiario()}`).text("Indirizzo Email obbligatorio.");
  } else {
    if (email.includes("@")) {
      var email_check = email.split("@");
      if (email_check[1].length == 0) {
        $(`#email_${get_tipo_beneficiario()}`).addClass("is-invalid");
        $(`#errore_email_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
        $(`#errore_email_${get_tipo_beneficiario()}`).text("Formato Email errato.");
      }
      else {
        if (!valida_mail(email)) {
          $(`#email_${get_tipo_beneficiario()}`).addClass("is-invalid");
          $(`#errore_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
          $(`#errore_${get_tipo_beneficiario()}`).text("Formato Email errato.");
        } else {
          $(`#email_${get_tipo_beneficiario()}`).removeClass("is-invalid");
          $(`#errore_email_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
          $(`#errore_email_${get_tipo_beneficiario()}`).text("");
        }
      }
    } else {
      if (!valida_mail(email)) {
        $(`#email_${get_tipo_beneficiario()}`).addClass("is-invalid");
        $(`#errore_email_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
        $(`#errore_email_${get_tipo_beneficiario()}`).text("Formato Email errato.");
      } else {
        $(`#email_${get_tipo_beneficiario()}`).removeClass("is-invalid");
        $(`#errore_email_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
        $(`#errore_email_${get_tipo_beneficiario()}`).text("");
      }
    }
  }
}

function valida_pec(pec) {
  if (pec.length == 0) {
    $(`#pec_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_pec_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_pec_${get_tipo_beneficiario()}`).text("Indirizzo PEC obbligatorio.");
  } else {
    if (pec.includes("@")) {
      var pec_check = pec.split("@");
      if (pec_check[1].length == 0) {
        $(`#pec_${get_tipo_beneficiario()}`).addClass("is-invalid");
        $(`#errore_pec_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
        $(`#errore_pec_${get_tipo_beneficiario()}`).text("Formato PEC errato.");
      } else {
        if (!valida_mail(pec)) {
          $(`#pec_${get_tipo_beneficiario()}`).addClass("is-invalid");
          $(`#errore_pec_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
          $(`#errore_pec_${get_tipo_beneficiario()}`).text("Formato PEC errato.");
        } else {
          $(`#pec_${get_tipo_beneficiario()}`).removeClass("is-invalid");
          $(`#errore_pec_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
          $(`#errore_pec_${get_tipo_beneficiario()}`).text("");
        }
      }
    } else {
      if (!valida_mail(pec)) {
        $(`#pec_${get_tipo_beneficiario()}`).addClass("is-invalid");
        $(`#errore_pec_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
        $(`#errore_pec_${get_tipo_beneficiario()}`).text("Formato PEC errato.");
      } else {
        $(`#pec_${get_tipo_beneficiario()}`).removeClass("is-invalid");
        $(`#errore_pec_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
        $(`#errore_pec_${get_tipo_beneficiario()}`).text("");
      }
    }
  }
}

function valida_telefono(telefono) {
  if (telefono.length === 0) {
    $(`#telefono_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_telefono_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_telefono_${get_tipo_beneficiario()}`).text("Recapito obbligatorio.");
  } else if (!/^\+?\d+$/.test(telefono)) {
    $(`#telefono_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_telefono_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_telefono_${get_tipo_beneficiario()}`).text("Inserire solo numeri.");
  } else {
    $(`#telefono_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_telefono_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_telefono_${get_tipo_beneficiario()}`).text("");
  }
}
function valida_cuua(cuua) {
  const tipo = get_tipo_beneficiario(); // recupera il tipo selezionato (singoli, associati, comuni)
  const $campo = $(`#cuua_${tipo}`);
  const $errore = $(`#errore_cuua_${tipo}`);

  // 🔥 normalizza in maiuscolo
  cuua = (cuua || "").toUpperCase();
  $campo.val(cuua); // aggiorna il campo nel form

  // 👉 Se il tipo è "comuni", il CUAA non è obbligatorio
  if (tipo === "comuni") {
    $campo.removeClass("is-invalid");
    $errore.removeClass("invalid-feedback").text("");
    return; // esce subito, nessuna validazione richiesta
  }

  // 👉 Negli altri casi (singoli, associati)
  if (cuua.length === 0) {
    $campo.addClass("is-invalid");
    $errore.addClass("invalid-feedback").text("Codice CUAA obbligatorio.");
  } else if (!controllaCFPIVA(cuua)) {
    $campo.addClass("is-invalid");
    $errore.addClass("invalid-feedback").text("Codice CUAA errato, assicurarsi di scriverlo in maiuscolo.");
  } else {
    $campo.removeClass("is-invalid");
    $errore.removeClass("invalid-feedback").text("");
  }
}

function valida_sede(sede) {
  if (sede.length == 0) {
    $(`#sede_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_sede_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_sede_${get_tipo_beneficiario()}`).text("Sede legale obbligatoria.");
  } else {
    $(`#sede_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_sede_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_sede_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_sede_indirizzo(sede_indirizzo) {
  if (sede_indirizzo.length == 0) {
    $(`#sede_indirizzo_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_sede_indirizzo_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_sede_indirizzo_${get_tipo_beneficiario()}`).text("Indirizzo della sede legale obbligatorio.");
  } else if (!reg_indirizzo.test(sede_indirizzo)) {
    $(`#sede_indirizzo_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_sede_indirizzo_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_sede_indirizzo_${get_tipo_beneficiario()}`).text("Indirizzo non valido.");
  } else {
    $(`#sede_indirizzo_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_sede_indirizzo_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_sede_indirizzo_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_sede_civico(civico_sede) {
  if (civico_sede.length == 0) {
    $(`#civico_sede_${get_tipo_beneficiario()}`).addClass("is-invalid");
    $(`#errore_civico_sede_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
    $(`#errore_civico_sede_${get_tipo_beneficiario()}`).text("Numero civico obbligatorio.");
  } else {
    $(`#civico_sede_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_civico_sede_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_civico_sede_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_denominazione(denominazione) {
  if (get_tipo_beneficiario() === "associati" || get_tipo_beneficiario() === "singoli") {
    if (denominazione.length == 0) {
      $(`#denominazione_${get_tipo_beneficiario()}`).addClass("is-invalid");
      $(`#errore_denominazione_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
      $(`#errore_denominazione_${get_tipo_beneficiario()}`).text("Nome dell'impresa obbligatorio.");
    } else {
      $(`#denominazione_${get_tipo_beneficiario()}`).removeClass("is-invalid");
      $(`#errore_denominazione_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
      $(`#errore_denominazione_${get_tipo_beneficiario()}`).text("");
    }
  } else {
    $(`#denominazione_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_denominazione_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_denominazione_${get_tipo_beneficiario()}`).text("");
  }
}

function valida_sede_provincia(sedeProvincia) {
  if (get_tipo_beneficiario() === "associati") {
    if (sedeProvincia.length == 0) {
      $(`#sede_provincia_${get_tipo_beneficiario()}`).addClass("is-invalid");
      $(`#errore_sede_provincia_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
      $(`#errore_sede_provincia_${get_tipo_beneficiario()}`).text("Provincia obbligatoria.");
    } else if (!reg_luogo_nascita_residenza.test(sedeProvincia)) {
      $(`#sede_provincia_${get_tipo_beneficiario()}`).addClass("is-invalid");
      $(`#errore_sede_provincia_${get_tipo_beneficiario()}`).addClass("invalid-feedback");
      $(`#errore_sede_provincia_${get_tipo_beneficiario()}`).text("Provincia non valida.");
    } else {
      $(`#sede_provincia_${get_tipo_beneficiario()}`).removeClass("is-invalid");
      $(`#errore_sede_provincia_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
      $(`#errore_sede_provincia_${get_tipo_beneficiario()}`).text("");
    }
  } else {
    $(`#sede_provincia_${get_tipo_beneficiario()}`).removeClass("is-invalid");
    $(`#errore_sede_provincia_${get_tipo_beneficiario()}`).removeClass("invalid-feedback");
    $(`#errore_sede_provincia_${get_tipo_beneficiario()}`).text("");
  }
}
function valida_n_imprese(numero_imprese, { silentIfEmpty = false } = {}) {
  // Valida solo se il tipo beneficiario è "associati"
  if (get_tipo_beneficiario() !== "associati") {
    $("#numero_imprese_agricole_associate").removeClass("is-invalid");
    $("#errore_numero_imprese_agricole_associate")
      .removeClass("invalid-feedback")
      .text("");
    return;
  }

  const raw = (numero_imprese ?? "").toString().trim();
  const $n = $("#numero_imprese_agricole_associate");
  const $err = $("#errore_numero_imprese_agricole_associate");

  if (raw.length === 0) {
    if (silentIfEmpty) {
      $n.removeClass("is-invalid");
      $err.removeClass("invalid-feedback").text("");
      return;
    }
    $n.addClass("is-invalid");
    $err.addClass("invalid-feedback").text("Campo obbligatorio.");
    return;
  }

  if (!/^\d+$/.test(raw)) {
    $n.addClass("is-invalid");
    $err.addClass("invalid-feedback").text("Inserire solo numeri interi.");
    return;
  }

  const n = parseInt(raw, 10);
  if (n < 2) { //  Ora minimo 2
    $n.addClass("is-invalid");
    $err.addClass("invalid-feedback").text("Il numero di imprese deve essere almeno 2.");
  } else {
    $n.removeClass("is-invalid");
    $err.removeClass("invalid-feedback").text("");
  }
}

function valida_cf(codiceFiscale) {
  const tipo = get_tipo_beneficiario();
  const $campo = $(`#codice_fiscale_${tipo}`);
  const $errore = $(`#errore_codice_fiscale_${tipo}`);

  // 🔠 Forza MAIUSCOLO e rimuove spazi
  codiceFiscale = (codiceFiscale || "").toString().trim().toUpperCase();
  $campo.val(codiceFiscale);

  if (tipo === "associati" || tipo === "comuni") {
    if (codiceFiscale.length === 0) {
      $campo.addClass("is-invalid");
      $errore.addClass("invalid-feedback").text("Codice Fiscale obbligatorio.");
    } else if (!controllaCFPIVA(codiceFiscale)) {
      $campo.addClass("is-invalid");
      $errore.addClass("invalid-feedback").text("Codice Fiscale errato.");
    } else {
      $campo.removeClass("is-invalid");
      $errore.removeClass("invalid-feedback").text("");
    }
  } else {
    $campo.removeClass("is-invalid");
    $errore.removeClass("invalid-feedback").text("");
  }
}

function valida_ccia(cciaRiferimento) {
  if (get_tipo_beneficiario() === "singoli") {
    if (cciaRiferimento.length == 0) {
      $("#ccia-riferimento").addClass("is-invalid");
      $("#errore_ccia_riferimento").addClass("invalid-feedback");
      $("#errore_ccia_riferimento").text("Provincia di riferimento della CCIA obbligatoria.");
    } else if (!reg_luogo_nascita_residenza.test(cciaRiferimento)) {
      $("#ccia-riferimento").addClass("is-invalid");
      $("#errore_ccia_riferimento").addClass("invalid-feedback");
      $("#errore_ccia_riferimento").text("Provincia della CCIA non valida.");
    } else {
      $("#ccia-riferimento").removeClass("is-invalid");
      $("#errore_ccia_riferimento").removeClass("invalid-feedback");
      $("#errore_ccia_riferimento").text("");
    }
  } else {
    $("#ccia-riferimento").removeClass("is-invalid");
    $("#errore_ccia_riferimento").removeClass("invalid-feedback");
    $("#errore_ccia_riferimento").text("");
  }
}

function valida_rea(numeroREA) {
  if (get_tipo_beneficiario() === "singoli") {
    if (numeroREA.length == 0) {
      $("#numero-rea").addClass("is-invalid");
      $("#errore_numero_rea").addClass("invalid-feedback");
      $("#errore_numero_rea").text("Numero REA obbligatorio.");
    } else if (!reg_rea.test(numeroREA)) {
      $("#numero-rea").addClass("is-invalid");
      $("#errore_numero_rea").addClass("invalid-feedback");
      $("#errore_numero_rea").text("Numero REA non valido. (es. MI123456)");
    } else {
      $("#numero-rea").removeClass("is-invalid");
      $("#errore_numero_rea").removeClass("invalid-feedback");
      $("#errore_numero_rea").text("");
    }
  } else {
    $("#numero-rea").removeClass("is-invalid");
    $("#errore_numero_rea").removeClass("invalid-feedback");
    $("#errore_numero_rea").text("");
  }
}

function valida_comune_riferimento(comuneRiferimento) {
  if (get_tipo_beneficiario() === "comuni") {
    var comuneRiferimento = $("#comune_riferimento").val();
    if (comuneRiferimento.length == 0) {
      $("#comune_riferimento").addClass("is-invalid");
      $("#errore_comune_riferimento").addClass("invalid-feedback");
      $("#errore_comune_riferimento").text("Comune obbligatorio.");
    } else if (!reg_luogo_nascita_residenza.test(comuneRiferimento)) {
      $("#comune_riferimento").addClass("is-invalid");
      $("#errore_comune_riferimento").addClass("invalid-feedback");
      $("#errore_comune_riferimento").text("Comune non valido.");
    } else {
      $("#comune_riferimento").removeClass("is-invalid");
      $("#errore_comune_riferimento").removeClass("invalid-feedback");
      $("#errore_comune_riferimento").text("");
    }
  } else {
    $("#comune_riferimento").removeClass("is-invalid");
    $("#errore_comune_riferimento").removeClass("invalid-feedback");
    $("#errore_comune_riferimento").text("");
  }
}

function valida_qualifica() {
  if ($(`input[name=qualifica_${get_tipo_beneficiario()}]:checked`).length > 0) {
    $(`#errore_qualifica_${get_tipo_beneficiario()}`).removeClass("invalid-feedback d-block");
    $(`#errore_qualifica_${get_tipo_beneficiario()}`).text("");
  } else {
    $(`#errore_qualifica_${get_tipo_beneficiario()}`).addClass("invalid-feedback d-block");
    $(`#errore_qualifica_${get_tipo_beneficiario()}`).text("Seleziona la qualifica.");
  }
}

// Mostra/Nasconde l'upload delega in base alla selezione
// Toggle upload + obbligatorietà "Numero Imprese..." in base al beneficiario
$(document).on("change", "input[name='tipo_beneficiario']", function () {
  const isAssociati = (($(this).val() || "").toLowerCase() === "associati");

  $("#upload_associati_container").toggleClass("d-none", !isAssociati);

  const $n = $("#numero_imprese_agricole_associate");
  $n.prop("required", isAssociati);

  // Validazione silenziosa se vuoto
  valida_n_imprese(($n.val() || "").trim(), { silentIfEmpty: true });
});


// Mostra/nasconde l'upload delega quando scelgo "Delegato"
$(document).on('change', 'input[name="qualifica_comuni"]', function () {
  const isDelegato = this.value === 'Delegato';
  const $wrap = $('[name="upload-delega"]');   // il tuo div .d-none
  const $file = $('#upload_delega');

  $wrap.toggleClass('d-none', !isDelegato);
  $file.prop('disabled', !isDelegato).prop('required', isDelegato);

  if (!isDelegato) {
    // pulizia quando torno su "Sindaco"
    $file.val('').removeClass('is-invalid');
    $('#errore_upload_delega').text('').removeClass('invalid-feedback d-block');
  }
});

// Stato iniziale corretto se un’opzione è già selezionata al load
$(function () {
  const $checked = $('input[name="qualifica_comuni"]:checked');
  if ($checked.length) $checked.trigger('change');
});
// Valida quando l'utente scrive
$(document).on("input blur", "#numero_imprese_agricole_associate", function () {
  const val = $(this).val().trim();
  valida_n_imprese(val);
});

// valida solo dopo interazione
$(document).on("input blur", "#numero_imprese_agricole_associate", function () {
  const val = $(this).val().trim();
  valida_n_imprese(val);
});

// Inizializza stato corretto al caricamento (rispetta il radio già selezionato)
$(function () {
  $("input[name='tipo_beneficiario']:checked").trigger("change");
});

// Validazione del file PDF della delega
$(document).on("change", "#upload_delega", function () {
  var file = this.files[0];
  var allowedExtensions = /(\.pdf)$/i;
  var maxSize = 5 * 1024 * 1024;

  if (!file) {
    $("#errore_upload_delega").text("Delega obbligatoria.");
    $("#upload_delega").addClass("is-invalid");
    $("#errore_upload_delega").addClass("invalid-feedback");
  } else if (!allowedExtensions.test(file.name)) {
    $("#errore_upload_delega").text("Formato non valido. Caricare solo file .pdf.");
    $("#upload_delega").addClass("is-invalid");
    $("#errore_upload_delega").addClass("invalid-feedback");
  } else if (file.size > maxSize) {
    $("#errore_upload_delega").text("Il file deve essere inferiore a 5MB.");
    $("#upload_delega").addClass("is-invalid");
    $("#errore_upload_delega").addClass("invalid-feedback");
  } else {
    $("#errore_upload_delega").text("");
    $("#upload_delega").removeClass("is-invalid");
    $("#errore_upload_delega").removeClass("invalid-feedback");
  }
});



//mostra o nascondi upload associazioni agricoltori
$(document).on("change", "input[name='tipo_beneficiario']", function () {
  const selected = $(this).val();

  if (selected === "associati") {
    $("#upload_associati_container").removeClass("d-none");
  } else {
    $("#upload_associati_container").addClass("d-none");
    $("#upload_associati").val(""); // reset file
  }
});

// validazione 
$(document).on("change", "#upload_associati", function () {
  var file = this.files[0];
  var allowedExtensions = /(\.pdf)$/i;
  var maxSize = 5 * 1024 * 1024;

  if (!file) {
    $("#errore_upload_associati").text("File obbligatorio.").addClass("invalid-feedback");
    $("#upload_associati").addClass("is-invalid");
  } else if (!allowedExtensions.test(file.name)) {
    $("#errore_upload_associati").text("Formato non valido. Solo PDF.").addClass("invalid-feedback");
    $("#upload_associati").addClass("is-invalid");
  } else if (file.size > maxSize) {
    $("#errore_upload_associati").text("Il file deve essere < 5MB.").addClass("invalid-feedback");
    $("#upload_associati").addClass("is-invalid");
  } else {
    $("#errore_upload_associati").text("").removeClass("invalid-feedback");
    $("#upload_associati").removeClass("is-invalid");
  }
});

//aggiunta di nuovi campi di upload facoltativi nella sezione “Documentazione allegata alla domanda di pagamento del saldo finale
// Aggiunta di nuovi campi di upload facoltativi
$(document).on("click", "#aggiungi_allegato", function () {
  const count = $("#upload_extra_container .upload-extra-group").length + 1;

  const campo = `
    <div class="mb-3 upload-extra-group">
      <label class="form-label">Documento facoltativo ${count}</label>
      <div class="d-flex gap-2">
        <input type="file" class="form-control" name="allegato_extra_${count}" accept=".pdf,.jpg,.jpeg,.png" />
        <button type="button" class="btn btn-danger btn-sm rimuovi-allegato">Rimuovi</button>
      </div>
    </div>`;

  $("#upload_extra_container").append(campo);
});

// Rimozione di un campo extra
$(document).on("click", ".rimuovi-allegato", function () {
  $(this).closest(".upload-extra-group").remove();

  // Rietichetta i rimanenti per mantenere numerazione coerente
  $("#upload_extra_container .upload-extra-group").each(function (index) {
    $(this).find("label").text(`Documento facoltativo ${index + 1}`);
    $(this).find("input[type='file']").attr("name", `allegato_extra_${index + 1}`);
  });
});

$(document).on("input", "input[id^=nome_]", function () {
  var nome = $(this).val();
  valida_nome(nome);
});

$(document).on("input", "input[id^=cognome_]", function () {
  var cognome = $(this).val();
  valida_cognome(cognome);
});

$(document).on("input", "input[id^=data-nascita_]", function () {
  var dataNascita = $(this).val();
  valida_data_nascita(dataNascita);
});

$(document).on("input", "input[id^=luogo-nascita_]", function () {
  var luogoNascita = $(this).val();
  valida_luogo_nascita(luogoNascita);
});

$(document).on("input", "input[id^=provincia-nascita_]", function () {
  var provinciaNascita = $(this).val();
  valida_provincia_nascita(provinciaNascita);
});

$(document).on("input", "input[id^=residenza_]", function () {
  var residenza = $(this).val();
  valida_residenza(residenza);
});

$(document).on("input", "input[id^=provincia_]", function () {
  var provincia = $(this).val();
  valida_provincia(provincia);
});

$(document).on("input", "input[id^=indirizzo_]", function () {
  var indirizzo = $(this).val();
  valida_indirizzo(indirizzo);
});

$(document).on("input", "input[id^=civico_]", function () {
  var civico = $(this).val();
  valida_civico(civico);
});

$(document).on("input", "input[id^=email_]", function () {
  var email = $(this).val();
  valida_email(email);
});

$(document).on("input", "input[id^=pec_]", function () {
  var pec = $(this).val();
  valida_pec(pec);
});

$(document).on("input", "input[id^=telefono_]", function () {
  var telefono = $(this).val().trim();
  valida_telefono(telefono);
});

$(document).on("input", "input[id^=cuua_]", function () {
  var cuua = $(this).val();
  valida_cuua(cuua);
});

$(document).on("input", "input[id^=sede_]", function () {
  var sede = $(this).val();
  valida_sede(sede);
});
// toogle per prima opzione cantierabilità
document.addEventListener("DOMContentLoaded", function () {
  const radioButtons = document.querySelectorAll('input[name="acquisizione-pareri"]');
  const periziaDiv = document.getElementById("upload_perizia_progettista");
  const entiListaDiv = document.getElementById("enti-preposti-lista");

  radioButtons.forEach(radio => {
    radio.addEventListener("change", function () {
      if (this.value === "no-necessita") {
        periziaDiv.classList.remove("d-none");
        entiListaDiv.classList.add("d-none");
      } else if (this.value === "necessita") {
        entiListaDiv.classList.remove("d-none");
        periziaDiv.classList.add("d-none");
      }
    });
  });
});


$(document).on("input", "input[id^=sede_indirizzo_]", function () {
  var sede_indirizzo = $(this).val();
  valida_sede_indirizzo(sede_indirizzo);
});

$(document).on("input", "input[id^=civico_sede_]", function () {
  var civico_sede = $(this).val();
  valida_sede_civico(civico_sede);
});

$(document).on("input", "input[id^=denominazione_]", function () {
  var denominazione = $(this).val();
  valida_denominazione(denominazione);
});

$(document).on("input", "input[id^=sede_provincia_]", function () {
  var sedeProvincia = $(this).val();
  valida_sede_provincia(sedeProvincia);
});

$(document).on("input", "#numero_imprese_agricole_associate", function () {
  // Prendiamo il valore così com'è, come stringa
  const numero_imprese = $(this).val().trim();
  valida_n_imprese(numero_imprese);
});

$(document).on("input", "input[id^=codice_fiscale_]", function () {
  var codiceFiscale = $(this).val();
  valida_cf(codiceFiscale);
});

$(document).on("input", "#ccia-riferimento", function () {
  var cciaRiferimento = $(this).val();
  valida_ccia(cciaRiferimento);
});

$(document).on("input", "#numero-rea", function () {
  var rea = $(this).val();
  valida_rea(rea);
});

$(document).on("input", "#comune_riferimento", function () {
  var comuneRiferimento = $(this).val();
  valida_comune_riferimento(comuneRiferimento);
});

$(document).on("change", "input[name=qualifica]", function () {
  $("#errore_qualifica").removeClass("invalid-feedback d-block");
  $("#errore_qualifica").text("");
});
